#ifndef KERNEL_H
#define KERNEL_H

#include "mkl_cblas.h"
#include "mkl_lapack.h"

#include <memory>
#include <vector>
#include <atomic>

#include "meta_task.h"

namespace kernel {
void compute(std::shared_ptr<meta_task> meta, int task_id);

void compute_panel(meta_task_ptr meta, int task_id);
void compute_b(meta_task_ptr meta, int task_id);
void compute_schur(meta_task_ptr meta, int task_id);
void compute_behind(meta_task_ptr meta, int task_id);
void compute_randomize(meta_task_ptr meta, int task_id);

void dlaswp_tiled(matrix_desc& mat/*descA*/, int i2);
void panel_recursion(matrix_desc& A, int* ipiv, double* pivot,
                     int t_id, int t_n, int col, int width, int ft, int lt);
void exchange_max(double localamx, int t_id, int t_n, int *t_win,
                  double *diagvalue, double *globalamx,
                  int pividx, int *ipiv, int col=0);
void barrier(int t_id, int t_n);

class exchange_field {
public:
    double sfmin;

    int  thread;
    double fin_value;
    double diag;

    volatile bool fin_flag;
    std::atomic_int counter;
    std::vector<double> value;

    exchange_field();
    void initialize(int t_n);
};

static kernel::exchange_field ex;

}
#endif // KERNEL_H
