#ifndef META_TASK
#define META_TASK

#include <vector>
#include <atomic>
#include <iostream>

#include "matrix_desc.h"

enum meta_function {
    PANEL               = 0,
    B                   = 1,
    SCHUR_COMPLEMENT    = 2,
    BEHIND_PANEL_UPDATE = 3,
    RANDOMIZE           = 4
};

enum task_status {
    NOT_READY,
    GLOB_QUEUE,
    LOCAL_QUEUE,
    RUNNING,
    FINISHED
};

class meta_task {
public:

    int id;

    meta_function type;
    task_status status;

    int k;			        // recursion depth
    int x;			        // top left tile x-coordinate
    int y;  		        // top left tile y-coordinate
    int meta_x; 		    // meta x-size
    int meta_y;		        // meta y-size

    int pri;                // priority
    int preferred_node;     // the node, that has the corresponding tile

    int nlocal;             // number of local jobs

    matrix_desc& matrix;

    // there might have to be a mutex for fulfilled or atomic ++
    std::atomic_int fulfilled;	 // first: number of fulfilled dependencies
                                 // later: reused as number of finished subtasks
    std::vector<int> in_dep;	 // ids of tasks this task depends upon
    std::vector<int> out_dep;	 // ids of tasks which are dependent on this task

    meta_task(int id, meta_function type, matrix_desc& matrix, int k, int x, int y, int meta_x, int meta_y, int pri, int preferred_node);

};

typedef std::shared_ptr<meta_task> meta_task_ptr;

#endif // META_TASK
