#ifndef META_TASK_SCHEDULER_H
#define META_TASK_SCHEDULER_H

#include <limits>
#include <vector>
#include <unordered_map>
#include <queue>
#include <atomic>

#include <memory>
#include <iostream>

#include <pthread.h>

#include "meta_task.h"

class priority_compare {
public:
    bool operator()(meta_task_ptr& m1, meta_task_ptr& m2)
    {
        return m1->pri > m2->pri;   // 0 is highest priority
    }
};
typedef std::priority_queue<meta_task_ptr,
                            std::vector<meta_task_ptr>,
                            priority_compare>
        priority_queue;


class meta_task_scheduler {
public:
    meta_task_scheduler();
    ~meta_task_scheduler();

    int newest_task;
    bool work_stealing;
    bool all_tasks_inserted;           // set by thread0
    volatile bool all_tasks_finished;  // set when the last task is marked finished

    void insertMetaTask(meta_task_ptr task);
    bool getMetaTask(int id, meta_task_ptr *meta);
    void finishMetaTask(meta_task_ptr task);

//private:    
    pthread_mutex_t task_hash_mutex;  // could be cut
    std::unordered_map<int, std::shared_ptr<meta_task> > task_hash;

    pthread_mutex_t ready_queue_mutex;
    std::vector<priority_queue> ready_queues;

    bool ready(meta_task &task);
    void insertTaskHash(meta_task_ptr meta);
    int  removeTaskHash(meta_task_ptr meta);
    void insertReadyQueue(meta_task_ptr meta);
};

#endif // META_TASK_SCHEDULER_H
