#ifndef UTILITY_H
#define UTILITY_H

#include <chrono>
#include <string>
#include <iostream>
#include <fstream>

#include "mkl_cblas.h"
#include "matrix_desc.h"
#include "context.h"

void copy_lower(matrix_desc& source, matrix_desc& target);
void copy_upper(matrix_desc& source, matrix_desc& target);
void multiply(matrix_desc& m1, matrix_desc& m2, matrix_desc& target);
void permute_back(matrix_desc& m, int* ipiv);
void print(matrix_desc& m);
void compare(matrix_desc& m1, matrix_desc& m2, matrix_desc& target);
void compare(matrix_desc& m1, matrix_desc& m2);
void copy(matrix_desc& s, matrix_desc& t);

void create_log(int n, int nb, std::chrono::high_resolution_clock::time_point start, long long time, std::string name);

#endif // UTILITY_H
