#ifndef CONTEXT_H
#define CONTEXT_H

/*
 * This flag enables the creation of our detailed computation logs.
 * The PAPI library is not needed while the generation of logs is turned off.
 */
#define CREATE_LOG

#include <pthread.h>
#include <numa.h>
#include <vector>
#include <chrono>

#include "meta_task.h"
#include "meta_task_scheduler.h"
#include "local_task_scheduler.h"

#ifdef CREATE_LOG
  #include "papi.h"
#endif

struct job_log
{
    int task_id;
    int x;
    int y;
    int k;
    int size_y;
    int thread_id;
    std::chrono::high_resolution_clock::time_point start;
    std::chrono::high_resolution_clock::time_point end;
    int pri;
    long long cache_m;
    long long cache_a;
};

class meta_thread
{
public:
    meta_thread(int id, int node, local_task_scheduler* loc);

    pthread_t thread;

    int id;
    int node;

    int work_count;

    local_task_scheduler* loc_scheduler;

    std::vector<job_log> log;
};


class meta_context
{
public:
    meta_context(const meta_context& c) = delete;
    meta_context& operator=(const meta_context& c) = delete;

    volatile bool finalize;

    std::vector<meta_thread> threads;
    std::vector<local_task_scheduler> node_scheduler;
    meta_task_scheduler scheduler;

    static meta_context& getContext()
    {
        static meta_context singleton;
        return singleton;
    }
    void initialize(int nthread, int node);
    void initialize(std::vector<int> cores, int node);
    void work_0();
    void cleanup();
    void shut_down();

private:
    meta_context();
};


#endif // CONTEXT_H
