#ifndef LOCAL_TASK_SCHEDULER_H
#define LOCAL_TASK_SCHEDULER_H

#include "meta_task.h"
#include "meta_task_scheduler.h"
#include "kernel.h"
#include <deque>
#include <memory>

#include <iostream>
#include <stdio.h>

//#define LOWER_LOCAL_WATERMARK 8
//#define HIGHER_LOCAL_WATERMARK 32

class local_task
{
public:
    local_task(int id, meta_task_ptr meta);
    local_task() = default;

    meta_task_ptr meta;
    int id;

    bool work();
};



class local_task_scheduler
{
public:
    local_task_scheduler(int id, meta_task_scheduler* global);
    ~local_task_scheduler();

    int id;
    int size;

    bool getTask(local_task *out);

    int meta_tasks_scheduled_here;

//private:
    meta_task_scheduler* global;

    pthread_mutex_t local_queue_mutex;
    std::deque<local_task> local_queue;
    bool looking_for_task;

    void fillLocalQueue();
    void segmentMetaTask(meta_task_ptr meta);

};

#endif // LOCAL_TASK_SCHEDULER_H
