#ifndef MATRIX_DESC
#define MATRIX_DESC

#include <cmath>
#include <memory>
#include <iostream>
#include <random>
#include "numa.h"


/*
 * Usually we assume that the physical memory, that corresponds to a tile of the matrix, is automatically allocated on the node that first writes to that tile.
 * (This is a policy of the operating system on our machine)
 * If this is not the case with your operating system, then the following flag will force the correct behavior using libnuma allocations.
 *
 * We have had problems using this variation, as libnuma has an upper limit to the number of allocations, that can be made.
 */
//#define FORCE_NUMA

class matrix_desc {
public:
    int n;      // #-columns
    int m;      // #-rows
    int nt;     // #-tile columns
    int mt;     // #-tile rows
    int nb;     // #-columns per tile
    int mb;     // #-rows per tile

    // needed for navigation within a matrix
    int col_size;   // #-elements within one column of tiles data[k*col_size] is beginning of a tile column

    // needed for submatrices to not free memory of the whole matrix
    bool submatrix;
    int ton;    // tile column offset (tile column in which the submatrix begins)
    int tom;    // tile row offset (tile row in which the submatrix begins)

    // submatrices will be pointing into this array
    // so submatrices will be invalid after the destruction of their whole matrix
    double** data;

    // permutation vector
    int* ipiv;

    matrix_desc(int m, int n, int mb, int nb);
    matrix_desc(matrix_desc& mat, int j, int i, int mt, int nt); // submatrix constructor
    ~matrix_desc();

    void initialize(int j, int i);
    double* operator() (std::size_t m, std::size_t n);

    int tn(std::size_t i);  // width of tiles in column i
    int tm(std::size_t j);  // height of tiles in row j
    double get(int j, int i);

};

#endif // MATRIX_DESC
